      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("ENV",                   %thinBasic_ReturnString,    CODEPTR(VarENV))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SCR",                   %thinBasic_ReturnString,    CODEPTR(VarSCR))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("PRO",                   %thinBasic_ReturnString,    CODEPTR(VarPRO))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FIL",                   %thinBasic_ReturnString,    CODEPTR(VarFIL))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FM",                    %thinBasic_ReturnString,    CODEPTR(VarFM))   '
FUNCTION VarENV() AS STRING                                       '
'--------------------------------------------------------------------------------------------------+
'- Fetch an ENV variable                                                                           |
'--------------------------------------------------------------------------------------------------+
   FUNCTION = VarFetch("ENV")                                     ' Use common routine
END FUNCTION                                                      '

FUNCTION VarSCR() AS STRING                                       '
'--------------------------------------------------------------------------------------------------+
'- Fetch an SCR variable                                                                           |
'--------------------------------------------------------------------------------------------------+
   FUNCTION = VarFetch("SCR")                                     ' Use common routine
END FUNCTION                                                      '

FUNCTION VarFIL() AS STRING                                       '
'--------------------------------------------------------------------------------------------------+
'- Fetch an FIL variable                                                                           |
'--------------------------------------------------------------------------------------------------+
   FUNCTION = VarFetch("FIL")                                     ' Use common routine
END FUNCTION                                                      '

FUNCTION VarFM() AS STRING                                       '
'--------------------------------------------------------------------------------------------------+
'- Fetch an FM variable                                                                            |
'--------------------------------------------------------------------------------------------------+
   FUNCTION = VarFetch("FM")                                      ' Use common routine
END FUNCTION                                                      '

FUNCTION VarPRO() AS STRING                                       '
'--------------------------------------------------------------------------------------------------+
'- Fetch a PRO variable                                                                            |
'--------------------------------------------------------------------------------------------------+
   FUNCTION = VarFetch("PRO")                                     ' Use common routine
END FUNCTION                                                      '

FUNCTION VarFetch(Which AS STRING) AS STRING                      '
'--------------------------------------------------------------------------------------------------+
'- Send back the ENV, SCR, FIL, PRO and FM variables                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL sName, oName, Ans, lcmd, t, u, iFile, iFileName, TstFileName, T1, T2, Oprand, lclnHiLites AS STRING
LOCAL i, j, k, BkpCount, vMode, IX AS LONG, EIX AS EXT, Sattr, lwText AS WSTRING
LOCAL lclattr AS WSTRING, lclPos AS LONG, AttrAsc AS WORD
LOCAL FileFD, RetFD AS DIRDATA                                    ' For directory data of the files                        '
   IF thinBasic_CheckPoint_Optional THEN
      oName = thinBasic_GetUnknownToken                           ' Get the variable name
      IF Which = "FIL" THEN gMacroTHeader = "FIL." + oName: QNotEdit(gMacroTHeader) ' Elim the not possible ones
      IF Which = "PRO" THEN gMacroTHeader = "PRO." + oName: QNotEdit(gMacroTHeader) '
      IF Which = "FM"  THEN gMacroTHeader = "FM."  + oName: QNotFM(gMacroTHeader)   '
      vMode = 9                                                   ' Default STRING mode to an error
      IF RIGHT$(oName, 1) = "#" THEN vMode = 0                    ' Set NUMERIC mode
      IF RIGHT$(oName, 1) = "$" THEN vMode = 1                    ' Set STRING  mode
      IF vMode = 9 THEN GOSUB KillIt                              ' Kill if no suffix
      sName = REMOVE$(oname, ANY "$#")                            ' Remove the codes
      IF Which = "ENV" THEN                                       ' Is this the ENV one?
         '-----------------------------------------------------------------------------------------+
         '- Handle the ENV variables                                                               |
         '-----------------------------------------------------------------------------------------+
         SELECT CASE CONST$ UCASE$(sName)
            CASE "EXEFULLNAME":    GOSUB KillNum:   Ans = gENV.EXEFullPath ' Full path to the EXE file
            CASE "EXEPATH":        GOSUB KillNum:   Ans = gENV.EXEPath     ' Path to the EXE folder
            CASE "HOMEDATA":       GOSUB KillNum:   Ans = gENV.HomeData    ' Home Folder for the Data sub-folders
            CASE "HOMEFOLDER":     GOSUB KillNum:   Ans = gENV.HomeFolder  ' Home Folder for CFG file
            CASE "INSTANCE":       GOSUB KillNum:   Ans = gENV.eInstance   ' INSTANCE name
            CASE "LINENUMSIZE":    GOSUB KillAlpha: Ans = FORMAT$(gENV.LinNoSize) ' Width of Line Number field
            CASE "MACNAME":        GOSUB KillNum:   Ans = gMacroName       ' Running Macro Name
            CASE "SPFVERSION":     GOSUB KillNum:   Ans = gENV.PgmVers     ' SPF Version
            CASE "TABNUM":         GOSUB KillAlpha: Ans = FORMAT$(TP.PgNumber)' Running Tab Number
            CASE "UNIQID":         GOSUB KillAlpha: Ans = FORMAT$((GetCurrentProcessId * 10000) + (TP.WindowID * 100))
            CASE "WORKINGDIR":     GOSUB KillNum:   Ans = gENV.WorkingDir  ' Our working directory
            CASE "ISFM":           Ans = IIF$(IsFMTab, "1", "0"): IF vMode THEN Ans = IIF$(Ans = "1", "YES", "NO")
            CASE "ISLINECMD"                                      ' IsLineCmd
               IF IsFMTab THEN                                    ' If FM then
                  j = IIF(gFMMacMode = 1, %True, %False)          ' Set the answer
               ELSE                                               '
                  lcmd = TRIM$(gLTblSCmd)                         ' Format the cmd name
                  IF lcmd = "" THEN                               ' If no Lcmd
                     j = %False                                   ' Pass back false
                  ELSE                                            '
                     i = gLCmdT.GetCmdIX(lcmd)                    ' See if source command is an internal line command
                     j = IIF(i, %False, %True)                    ' Pass back answer
                  END IF                                          '
               END IF                                             '
               Ans = IIF$(vMode, IIF$(j, "YES", "NO"), FORMAT$(j))   ' IsPrimaryCmd
            CASE "ISPRIMARYCMD"                                   ' IsLineCmd
               IF IsFMTab THEN                                    ' If FM then
                  j = IIF(gFMMacMode = 0, %True, %False)          ' Set the answer
               ELSE                                               '
                  lcmd = TRIM$(gLTblSCmd)                         ' Format the cmd name
                  IF lcmd = "" THEN                               ' If no Lcmd
                     j = %True                                    ' Pass back true
                  ELSE                                            '
                     i = gLCmdT.GetCmdIX(lcmd)                    ' See if source command is an internal line command
                     j = IIF(i, %True, %False)                    ' Pass back answer
                  END IF                                          '
               END IF                                             '
               Ans = IIF$(vMode, IIF$(j, "YES", "NO"), FORMAT$(j))   ' Setup the answer
         END SELECT                                               '
         IF ISNOTNULL(Ans) THEN                                   ' Did the above answer it?
            FUNCTION = Ans                                        ' Yes, Pass back the value
            TP.ErrMsgReset:                                       ' Reset errors
            DoTraceS(Ans)                                         ' Do trace if needed
            EXIT FUNCTION                                         ' We're done
         END IF                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Handle the ENV variables needing an Operand                                            |
         '-----------------------------------------------------------------------------------------+
         IF thinBasic_CheckOpenParens_Optional THEN               ' Grab the operand
            thinBasic_ParseString(Oprand)                         '
            thinBasic_CheckCloseParens_Mandatory                  '
         END IF                                                   '
         IF thinBasic_ErrorFree THEN                              '
            SELECT CASE CONST$ UCASE$(sName)
               CASE "SYSVAR":         GOSUB KillNum:   Ans = ENVIRON$(Oprand)
            END SELECT                                            '
         END IF
         '-----------------------------------------------------------------------------------------+
         '- We have something, return it                                                           |
         '-----------------------------------------------------------------------------------------+
         FUNCTION = Ans                                           ' Pass back the value
         TP.ErrMsgReset:                                          ' Reset errors
         DoTraceS(Ans)                                            ' Do trace if needed

      ELSEIF Which = "SCR" THEN                                   '
         '-----------------------------------------------------------------------------------------+
         '- Handle the SCR variables                                                               |
         '-----------------------------------------------------------------------------------------+
         SELECT CASE CONST$ UCASE$(sName)
            CASE "CSRCOL":      GOSUB KillAlpha: Ans = FORMAT$(IIF(ISFALSE TP.CursData, 0, TP.CsrCol - TP.GPGapCol + TP.GPOffset))  ' Return the cursor column
            CASE "CSRCURRLINE": GOSUB KillNum:   Ans = TP.CursLine                    ' Current cursor line text
            CASE "CSRCURRWORD": GOSUB KillNum:   Ans = TP.CursWord                    ' Current cursor word
            CASE "CSRLNUM":     GOSUB KillAlpha: Ans = FORMAT$(VAL(TP.LLNumGet(TP.sGet(TP.CsrRow)))) ' Return the cursor Line Number
            CASE "CSRLPTR":     GOSUB KillAlpha: Ans = FORMAT$(TP.sGet(TP.CsrRow))       ' Return the cursor LPtr
            CASE "HEIGHT":      GOSUB KillAlpha: Ans = FORMAT$(gENV.ScrHeight)           ' Total Screen height
            CASE "LEFTCOL":     GOSUB KillAlpha: Ans = FORMAT$(TP.GPOffset + 1)          ' Return the leftmost column on Panel/Screen
            CASE "PANELHEIGHT": GOSUB KillAlpha: Ans = FORMAT$(TP.GPPanelHeight)         ' Return the rightmost column on Panel/Screen
            CASE "PANELWIDTH":  GOSUB KillAlpha: Ans = FORMAT$(TP.GPPanelWidth)          ' Return the panel width
            CASE "RIGHTCOL":    GOSUB KillAlpha: Ans = FORMAT$(TP.GPOffset + TP.GPDataLen) ' Return the rightmost column on Panel/Screen
            CASE "TOPSCRLPTR":  GOSUB KillAlpha: Ans = FORMAT$(TP.GPTopLine)             ' LPtr of the top line in the Panel/Screen
            CASE "TXTCOLUMNS":  GOSUB KillAlpha: Ans = FORMAT$(TP.GPDataLen)             ' No. of text columns on Panel/Screen
            CASE "TXTLINES":    GOSUB KillAlpha: Ans = FORMAT$(TP.GPDLines)              ' No. of text data lines on Panel/Screen
            CASE "WIDTH":       GOSUB KillAlpha: Ans = FORMAT$(gENV.ScrWidth)            ' Total Screen width

            CASE ELSE                                             ' Unknown?
               GOSUB Killit                                       ' Kill with a message
         END SELECT                                               '
         '-----------------------------------------------------------------------------------------+
         '- We have something, return it                                                           |
         '-----------------------------------------------------------------------------------------+
         FUNCTION = Ans                                           ' Pass back the value
         TP.ErrMsgReset:                                          ' Reset errors
            DoTraceS(Ans)                                            ' Do trace if needed

      ELSEIF Which = "FIL" THEN                                   '
         '-----------------------------------------------------------------------------------------+
         '- Handle the FIL variables                                                               |
         '-----------------------------------------------------------------------------------------+
         SELECT CASE CONST$ UCASE$(sName)                         '
            CASE "BASENAME":       GOSUB KillNum: GOSUB MaybeClip: IF ISNULL(Ans) THEN Ans = TP.FCB_.Base
            CASE "DATE":           GOSUB KillNum: Ans = IIF$((IsClip AND ISNULL(TP.Clipname)) OR IsSetEdit OR IsEFTEdit, _
                                              RIGHT$(DATE$, 2) + "-" + LEFT$(DATE$, 2) + "-" + MID$(DATE$, 4, 2), _
                                              TP.FCB_.Date)
            CASE "EXT":            GOSUB KillNum: Ans = IIF$((IsClip AND ISNULL(TP.Clipname)) OR IsSetEdit OR IsEFTEdit, "", TP.FCB_.Extn)
            CASE "FIRSTREALLPTR":
                                   Ans = "0"                                                      ' If not found
                                   FOR i = 1 TO TP.LastLine                                       ' Look for First Data line
                                      IF ISTRUE (TP.LFlagGet(i) AND %Data) THEN                   ' Found a Data Line?
                                         Ans = FORMAT$(i): EXIT FOR                                  ' Return the LPtr
                                       END IF                                                     '
                                   NEXT i                                                         '
            CASE "FULLNAME":       GOSUB KillNum: GOSUB MaybeClip: IF ISNULL(Ans) THEN Ans = TP.FCB_.FilePath
            CASE "FILENAME":       GOSUB KillNum: GOSUB MaybeClip: IF ISNULL(Ans) THEN Ans = TP.FCB_.File
            CASE "PATH":           GOSUB KillNum: GOSUB MaybeClip: IF ISNULL(Ans) THEN Ans = TP.FCB_.Path
            CASE "TIME":           GOSUB KillNum: Ans = IIF$((IsClip AND ISNULL(TP.Clipname)) OR IsSetEdit OR IsEFTEdit, LEFT$(TIME$, 8), TP.FCB_.Time)
            CASE "FIRSTLPTR":      Ans = FORMAT$(IIF(TP.LastLine = 2, 0, 1))
            CASE "LASTLPTR":       Ans = FORMAT$(IIF(TP.LastLine = 2, 0, TP.LastLine))
            CASE "LASTREALLPTR":
                                   Ans = "0"                                                      ' If not found
                                   FOR i = TP.LastLine TO 1 STEP -1                               ' Look for Last Data line
                                      IF ISTRUE (TP.LFlagGet(i) AND %Data) THEN                   ' Found a Data Line?
                                         Ans = FORMAT$(i): EXIT FOR                                  ' Return the LPtr
                                       END IF                                                     '
                                   NEXT i                                                         '
            CASE "MODIFIED":       Ans = FORMAT$(IIF(IsTPModdFlag, %True, %False))                   '
         END SELECT                                               '
         IF ISNOTNULL(Ans) THEN                                   ' Did the above answer it?
            FUNCTION = Ans                                        ' Yes, Pass back the value
            TP.ErrMsgReset:                                       ' Reset errors
            DoTraceS(Ans)                                         ' Do trace if needed
            EXIT FUNCTION                                         ' We're done
         END IF                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Handle the FIL variables needing an Operand                                            |
         '-----------------------------------------------------------------------------------------+
         IF thinBasic_CheckOpenParens_Optional THEN               ' Grab the operand
            thinBasic_ParseNumber(eIX): IX = eIX                  '
            thinBasic_CheckCloseParens_Mandatory                  '
         END IF                                                   '
         IF thinBasic_ErrorFree THEN                              '
            IF ix < 1 OR ix > TP.LastLine THEN                    ' Invalid line IX?
               FUNCTION = "": TP.ErrMsgAdd(8, "Not a valid line number")  ' Else pass back null
               DoTraceS(""): EXIT FUNCTION                        '
            END IF                                                '
            SELECT CASE CONST$ UCASE$(sName)                      '
               CASE "CLRLINE"
                                   GOSUB KillNum: GOSUB KillNoData ' Ensure alpha and a Data Line
                                   lclnHiLites = " " + gHiLitesChrs                            ' Get string with a blank
                                   lwText = TP.LAttrGet(IX): Ans = ""                          ' Get the Attr line, null answer line
                                   FOR j = 1 TO LEN(lwText)                                    ' Convert to old Clr line format
                                      AttrAsc = ASC(lwText, j) AND %AttrHiLite                 ' Get Attr without the HiLite bits
                                      SHIFT RIGHT AttrAsc, 12                                  ' Align it properly
                                      Ans += MID$(lclnHiLites, AttrAsc + 1, 1)                 ' Get HiLite Index
                                   NEXT j                                                      '
                                   IF TRIM$(Ans) = "" THEN Ans = SPACE$(TP.LTxtLen(IX))        ' fudge one

               CASE "LINE":    GOSUB KillNum: Ans = IIF$(ix > 0 AND ix < TP.LastLine, TP.LTxtGet(IX), "")   '
            END SELECT                                            '
         END IF

         '-----------------------------------------------------------------------------------------+
         '- We have something, return it                                                           |
         '-----------------------------------------------------------------------------------------+
         FUNCTION = Ans                                           ' Pass back the value
         TP.ErrMsgReset:                                          ' Reset errors
         DoTraceS(Ans)                                            ' Do trace if needed

      ELSEIF Which = "PRO" THEN                                   '
         SELECT CASE CONST$ UCASE$(sName)
            CASE "NAME":      GOSUB KillNum: Ans = TP.FCB_.ProfName
            CASE "ACTION":    GOSUB KillNum: Ans = IIF$(TP.FCB_.Actionsave, FORMAT$(TP.FCB_.ActionSave), "OFF")
            CASE "ANSI2SOURCETABLE": GOSUB KillNum: Ans = IIF$(TP.FCB_.SrceXlate, TP.FCB_.CA2S, "")
            CASE "AUTOBKUP":  Ans = IIF$(TP.FCB_.AutoBkup, "1", "0"): IF VMode THEN Ans = IIF$(Ans = "1", "ON", "OFF")
            CASE "AUTOCAPS":  Ans = IIF$(TP.FCB_.AutoCaps, "1", "0"): IF VMode THEN Ans = IIF$(Ans = "1", "ON", "OFF")
            CASE "AUTONAME":  GOSUB KillNum: Ans = IIF$(TP.FCB_.AutoName = "$NONE$", "NONE", TP.FCB_.AutoName)
            CASE "AUTOSAVE":  GOSUB KillNum: Ans = IIF$((TP.FCB_.AutoSave AND 1) = 1, "ON ", "OFF ") + IIF$((TP.FCB_.AutoSave AND 2) = 2, "PROMPT", "NOPROMPT")
            CASE "BNDS":      GOSUB KillNum: Ans = FORMAT$(TP.FCB_.BndLeft) + " THRU " + IIF$(TP.FCB_.BndRight= 0, "MAX", FORMAT$(TP.FCB_.BndRight))
            CASE "BNDSLINE"
                              GOSUB KillNum                       '
                              TP.FCB_.BuildBndText                '
                              Ans = TP.BndText                    '
            CASE "BOM":       Ans = IIF$(TP.FCB_.BOM, "1", "0"): IF VMode THEN Ans = IIF$(Ans = "1", "ON", "OFF")
            CASE "CAPS"
                              GOSUB KillNum                       '
                              IF TP.FCB_.CapsDesired <> 2 THEN    '
                                 Ans = IIF$(TP.FCB_.CapsDesired, "ON", "OFF")
                              ELSE                                '
                                 Ans = IIF$(TP.FCB_.CapsActual, "AUTO:on", "AUTO:off")
                              END IF                              '
            CASE "CASE":      GOSUB KillNum: Ans = UUCASE(TP.FCB_.CaseFlag)
            CASE "CHANGE":    GOSUB KillNum: Ans = IIF$(TP.FCB_.ChangeMode = "D", "DS", "CS")
            CASE "COLLATE":   GOSUB KillNum: Ans = TP.FCB_.CollateStr
            CASE "COLS":      Ans = IIF$(TP.FCB_.Cols, "1", "0"): IF VMode THEN Ans = IIF$(Ans = "1", "ON", "OFF")
            CASE "COMMENTS":  GOSUB KillNum: Ans = FORMAT$(TP.FCB_.CmntID) + " " + FORMAT$(TP.FCB_.CmntCol) + " " + _
                                    FORMAT$(TP.FCB_.CmntIncr) + " " + FORMAT$(TP.FCB_.CmntEnd)
            CASE "DCB":       GOSUB KillNum: Ans = TP.FCB_.RECFM + " " + FORMAT$(TP.FCB_.LRECL) + " " + IIF$(VERIFY(TP.FCB_.EOL, $Hex) = 0, "X'" + TP.FCB_.EOL + "'", TP.FCB_.EOL) '
            CASE "EFT":       GOSUB KillNum: Ans = TP.EFTOVListG(0)
            CASE "EMACRO"
                              GOSUB KillNum
                              Ans = IIF$(ISNULL(TP.FCB_.EMacro), "NONE", uucase(TP.FCB_.EMacro)) '
                              IF Ans <> "NONE" THEN Ans += IIF$(uucase(TP.FCB_.EMacro) = TP.FCB_.EMacro, " ON", " OFF") '
            CASE "EOL":       GOSUB KillNum: Ans = IIF$(VERIFY(TP.FCB_.EOL, $Hex) = 0, "X'" + TP.FCB_.EOL + "'", TP.FCB_.EOL)
            CASE "EOLSTR"
                              GOSUB KillNum:
                              t = TP.FCB_.EOL                     ' Get the EOL
                              IF t = "CRLF" THEN                  ' Setup the EOL delimiter
                                 Ans = $CRLF                      '
                              ELSEIF t = "LF" THEN                '
                                 Ans = $LF                        '
                              ELSEIF t = "CR" THEN                '
                                 Ans = $CR                        '
                              ELSEIF t = "NL" THEN                '
                                 Ans = $NL                        '
                              ELSEIF t = "NONE" THEN              '
                                 Ans = ""                         '
                              ELSEIF LEFT$(t, 4) = "AUTO" THEN    '
                                 Ans = $CRLF                      '
                              ELSE                                ' Must be hex
                                 Ans = StrFromHex(TRIM$(t))       ' Set it up
                              END IF                              '
            CASE "HEX":       Ans = IIF$(TP.FCB_.HexMode, "1", "0"): IF VMode THEN Ans = IIF$(Ans = "1", "ON", "OFF")
            CASE "HIDE":      GOSUB KillNum: Ans = "X " +IIF$(IsTPHideFlag, "ON", "OFF") + " FILE " + IIF$(IsTPFileHide, "ON", "OFF")

            CASE "HILITE":
                              GOSUB KillNum:                      '
                              IF ISFALSE TP.FCB_.HiFind AND ISFALSE TP.FCB_.HiAuto THEN
                                 Ans = "OFF"                      '
                              ELSE                                '
                                 Ans = "FIND " + IIF$(TP.FCB_.HiFind, "ON", "OFF") + _
                                       " AUTO " + IIF$(TP.FCB_.HiAuto, "ON", "OFF")
                              END IF                              '
            CASE "IMACRO"
                              GOSUB KillNum:                      '
                              Ans = IIF$(ISNULL(TP.FCB_.IMacro), "NONE", uucase(TP.FCB_.IMacro))
                              IF Ans <> "NONE" THEN Ans += IIF$(uucase(TP.FCB_.IMacro) = TP.FCB_.IMacro, " ON", " OFF")
            CASE "INCLUDE":   GOSUB KillNum:   Ans = IIF$(TP.FCB_.PInclude = "", "NONE", TP.FCB_.PInclude)
            CASE "LBOUND":    GOSUB KillAlpha: Ans = FORMAT$(TP.FCB_.BndLeft)       '
            CASE "LOCK":      GOSUB KillNum:   Ans = IIF$(TP.FCB_.LockFlag, "LOCKED", "UNLOCKED")
            CASE "LRECL":     GOSUB KillAlpha: Ans = FORMAT$(TP.FCB_.LRECL)
            CASE "MACLIB":    GOSUB KillNum:   Ans = IIF$(ISNULL(TP.FCB_.Maclib), "NONE", TP.FCB_.Maclib)
            CASE "MARK":      Ans = IIF$(TP.FCB_.MarkFlag, "1", "0"): IF VMode THEN Ans = IIF$(Ans = "1", "ON", "OFF")
            CASE "MARKLINE":  GOSUB KillNum:   Ans = IIF$(ISNULL(TP.FCB_.MarkLine), "NONE", TP.FCB_.MarkLine)
            CASE "MASK":      GOSUB KillNum:   Ans = IIF$(ISNULL(TP.FCB_.MaskLine), "NONE", TP.FCB_.MaskLine)
            CASE "MASKLINE":  GOSUB KillNum:   Ans = IIF$(ISNULL(TP.FCB_.MaskLine), "NONE", TP.FCB_.MaskLine)
            CASE "MINLEN":    GOSUB KillAlpha: Ans = FORMAT$(TP.FCB_.MINLEN)
            CASE "MODE":      GOSUB KillNum:   Ans = SWITCH$(TP.FCB_.MODE = %Edit, "EDIT", TP.FCB_.MODE = %View, "VIEW", TP.FCB_.MODE = %Browse, "BROWSE")
            CASE "NOTIFY":    GOSUB KillNum:   Ans = SWITCH$(gENV.NotifyLevel= 0, "NONE", gENV.NotifyLevel= 1, "EDIT", gENV.NotifyLevel= 2, "ALL") '
            CASE "PAGE":      GOSUB KillNum:   Ans = IIF$(TP.FCB_.PageFlag, IIF$(TP.FCB_.PageFlag = 2, "SCROLL", "ON"), "OFF") + IIF$(TP.FCB_.PageOffset <> 0, "/" + FORMAT$(TP.FCB_.PageOffset, "+#;-#"), "")
            CASE "PRESERVE":  GOSUB KillNum:   Ans = IIF$(TP.FCB_.PreserveTyp = 0 , "OFF", IIF$(TP.FCB_.PreserveTyp = 1, "ON", "C"))
            CASE "RBOUND":    GOSUB KillAlpha: Ans = FORMAT$(TP.FCB_.BndRight)      '
            CASE "RECFM":     GOSUB KillNum:   Ans = TP.FCB_.RECFM
            CASE "SCROLL":    GOSUB KillNum:   Ans = TP.FCB_.ScrollAmt
            CASE "SOURCE":    GOSUB KillNum:   Ans = TP.FCB_.SourceName
            CASE "SOURCE2ANSITABLE": GOSUB KillNum: Ans = IIF$(TP.FCB_.SrceXlate, TP.FCB_.SS2A, "")
            CASE "START":     GOSUB KillNum:   Ans = TP.FCB_.Start
            CASE "STATE":     Ans = IIF$(TP.FCB_.StateFlag, "1", "0"): IF VMode THEN Ans = IIF$(Ans = "1", "ON", "OFF")
            CASE "SUBARG":    GOSUB KillNum:   Ans = IIF$(ISNULL(TP.FCB_.SubArg), "NONE", TP.FCB_.SubArg)
            CASE "SUBCMD":    GOSUB KillNum:   Ans = IIF$(ISNULL(TP.FCB_.SubCmd), "NONE", TP.FCB_.SubCmd)
            CASE "TABBNDS":   Ans = IIF$(TP.FCB_.TabBNDS, "1", "0"): IF VMode THEN Ans = IIF$(Ans = "1", "ON", "OFF")
            CASE "TABS":      Ans = IIF$(TP.FCB_.Tabs, "1", "0"): IF VMode THEN Ans = IIF$(Ans = "1", "ON", "OFF")
            CASE "TABSLINE":  GOSUB KillNum:   Ans = IIF$(ISNULL(TP.FCB_.TabsLine), "NONE", TP.FCB_.TabsLine)
            CASE "WORD":      GOSUB KillNum:   Ans = TP.FCB_.WordStr
            CASE "XFORM"
                              GOSUB KillNum                       '
                              Ans = IIF$(ISNULL(TP.FCB_.XFormStr), "NONE", uucase(TP.FCB_.XFormStr))
                              IF Ans <> "NONE" THEN Ans += IIF$(uucase(TP.FCB_.XFormStr) = TP.FCB_.XFormStr, " ON", " OFF")   '

            CASE "XTABS":     GOSUB KillAlpha: Ans = FORMAT$(TP.FCB_.ImportTabs)
            CASE ELSE                                             ' Unknown?
               TP.ErrMsgAdd(8, sname + " is an unsupported PRO variable") ' Set ZRC to fail
            FUNCTION = "": DoTraceS("")                           ' Setup return
            thinBasic_RunTimeError(%ERR__NOT_VAR, _               ' Force a thinBasic error
                                   sname + " is an unsupported PRO variable")
            EXIT FUNCTION                                         ' Error exit                                                   '
         END SELECT                                               '
         '-----------------------------------------------------------------------------------------+
         '- We have something, return it                                                           |
         '-----------------------------------------------------------------------------------------+
         FUNCTION = Ans                                           ' Pass back the value
         TP.ErrMsgReset:                                          ' Reset errors
         DoTraceS(Ans)                                            ' Do trace if needed

      ELSEIF Which = "FM" THEN                                    '
         '-----------------------------------------------------------------------------------------+
         '- Handle the Basic FM variables                                                          |
         '-----------------------------------------------------------------------------------------+
         Ans = ""                                                 ' Null answer
         SELECT CASE CONST$ UCASE$(sName)
            CASE "FCOUNT":          GOSUB KillAlpha: Ans = FORMAT$(TP.gFMDCtr - 1)  ' Return the file count
            CASE "FILEPATH":        GOSUB KillNum  : Ans = TP.FPath              ' Return the file path
            CASE "FILEPATTERN":     GOSUB KillNum  : Ans = TP.FMask              ' Return the file mask
            CASE "FLISTNAME":       GOSUB KillNum  : Ans = TP.FileListNm: IF ISNULL(Ans) THEN Ans = "Null" ' Return the FList name
            CASE "MODE":            GOSUB KillAlpha                              '
                                    IF ISNULL(TP.FileListNm) THEN                ' If no Filelist name
                                       Ans = "1"                                 ' Then it's FilePath mode
                                    ELSE                                         '
                                       SELECT CASE AS CONST$ TP.FileListNm       ' It's a FLIST type
                                          CASE "Recent Files":    Ans = "2"      '
                                          CASE "Found Files":     Ans = "3"      '
                                          CASE "Open Files":      Ans = "4"      '
                                          CASE "Favorite Files":  Ans = "5"      '
                                          CASE "FLISTS":          Ans = "6"      '
                                          CASE "Recent Paths":    Ans = "7"      '
                                          CASE "Configs":         Ans = "8"      '
                                          CASE ELSE:              Ans = "0"      '
                                       END SELECT                                '
                                    END IF                                       '
                                                                  '
         END SELECT                                               '
         IF ISNOTNULL(Ans) THEN                                   ' Did the above answer it?
            FUNCTION = Ans                                        ' Yes, Pass back the value
            TP.ErrMsgReset:                                       ' Reset errors
            DoTraceS(Ans)                                         ' Do trace if needed
            EXIT FUNCTION                                         ' We're done
         END IF                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Handle the FM variables needing a Line Index                                           |
         '-----------------------------------------------------------------------------------------+
         IF thinBasic_CheckOpenParens_Optional THEN               ' Grab the index
            thinBasic_ParseNumber(EIX): IX = EIX                  '
            thinBasic_CheckCloseParens_Mandatory                  '
         END IF                                                   '
         IF thinBasic_ErrorFree THEN                              '
            SELECT CASE CONST$ UCASE$(sName)
               CASE "ATTR":            Ans = IIF$(vMode, gFMD(IX).PrtField("ATTR", lclAttr, lclPos), FORMAT$(gFMD(ix).FileAttributes))
               CASE "BACKUPVERSIONS"
                                       GOSUB KillAlpha                                                ' Should be numeric
                                       IF ISFALSE ISFOLDER(TRIM$(gFMD(IX).DPath) + "$BACKUP") THEN    ' If no $BACKUP folder
                                          Ans = "0"                                                   ' Then no Backups, answer is zero
                                       ELSE                                                           ' Continue
                                          iFileName = gFMD(IX).FullPath                               ' Build the full Path/Filename
                                          t = DIR$(iFileName TO FileFD)                               ' Get the full FD set of data
                                          IF t = "" THEN                                              ' Not found?
                                             Ans = "0"                                                ' Then no Backups, answer is zero
                                          ELSE                                                        ' Continue
                                             iFile = PATHNAME$(NAMEX, iFileName)                      ' Get just the file.Ext
                                             '-----------------------------------------------------------------------------------------------+
                                             '- Count existing backups                                                                       |
                                             '-----------------------------------------------------------------------------------------------+
                                             TSTFileName = TRIM$(gFMD(IX).DPath) + "$BACKUP\" + iFile + ".*" ' Build generic (no stamp) search version
                                             BKPCount = 0                                             '
                                             u = PCRERegexCompile("\.[0-9]{6}\-[0-9]{6}\.[0-9]{6}")   ' Look for our timestamp pattern
                                             t = DIR$(TSTFileName, TO RetFD)                          ' Look for Backups
                                             DO WHILE ISNOTNULL(t)                                    ' While we're getting entries
                                                PCRERegexTest(t, 1, j, k)                             ' See if has our pattern
                                                IF j  AND RIGHT$(t, 6) <> ".STATE" THEN               ' Got one, and NOT a STATE file
                                                   INCR BKPCount                                      ' Bump counter
                                                END IF                                                '
                                                t = DIR$(NEXT)                                        ' Get next entry
                                             LOOP                                                     '
                                             Ans = FORMAT$(BKPCount)                                     ' Pass back the answer
                                          END IF                                                      '
                                       END IF                                                         '
               CASE "CMD":             GOSUB KillNum  : Ans = SHRINK$(gFMD(IX).Cmd)
               CASE "CREATIONTIME":    GOSUB KillNum  : Ans = TimePretty(gFMD(IX).CreationTime)
               CASE "EXTENSION":       GOSUB KillNum  : Ans = FORMAT$(IIF(ISFALSE TP.CursData, 0, TP.CsrCol - TP.GPGapCol + TP.GPOffset))  ' Return the cursor column
               CASE "FILECLASS":       GOSUB KillAlpha
                                       t1 = TRIM$(gFMD(IX).FileName)                                  ' Get the filename
                                       t2 = PCRERegexCompile("\.[0-9]{6}\-[0-9]{6}\.[0-9]{6}")        ' Check for .999999-999999.999999 timestamp
                                       PCRERegexTest(t1, 1, i, j)                                     ' See if we can find it
                                       IF i = 0 OR j <> 21 THEN                                       ' Possible Backup type?
                                          Ans = "1"                                                   ' No, return 1 = FM_EQU_NORMAL_FILE
                                       ELSE                                                           ' Yes
                                          Ans = IIF$(RIGHT$(t1, 6) = ".STATE", "3", "2")              ' Return 2 for FM_EQU_BACKUP_DATA, 3 for FM_EQU_BACKUP_STATE
                                       END IF                                                         '
               CASE "FILENAME":        GOSUB KillNum  : Ans = TRIM$(gFMD(IX).FileName)
               CASE "FILESIZE":        GOSUB KillAlpha: i = gFMD(IX).SizeInt: Ans = FORMAT$(i)
               CASE "FTYPE"
                                       GOSUB KillAlpha
                                       SELECT CASE AS LONG gFMD(IX).fLAG                              ' See what we have
                                          CASE %FDirUp:                   Ans = "1"                   ' Dir Up
                                          CASE %FDirDown:                 Ans = "2"                   ' Dir Down
                                          CASE %FEntry:                   Ans = "3"                   ' File (in FILEPATH)
                                          CASE %FFLEntry:                 Ans = "3"                   ' File (in an FLIST)
                                          CASE %FOpen:                    Ans = "3"                   ' File (in OPEN list)
                                          CASE %FPath:                    Ans = "4"                   ' Entry (in the Paths list)
                                          CASE %FFileList:                Ans = "5"                   ' FLIST (in the FLIST list)
                                          CASE %FConfig:                  Ans = "6"                   ' Entry (in the CONFIG List)
                                          CASE ELSE:                      Ans = "0"                   ' Unknown
                                       END SELECT                                                     '
               CASE "LINES":           GOSUB KillAlpha: Ans = FORMAT$(gFMD(IX).LinesInt)
               CASE "PATH":            GOSUB KillNum  : Ans = TRIM$(gFMD(IX).DPath)
               CASE "PRP1":            GOSUB KillNum  : Ans = gFMD(IX).PrtField("PRP1", lclAttr, lclPos)
               CASE "PRP2":            GOSUB KillNum  : Ans = gFMD(IX).PrtField("PRP2", lclAttr, lclPos)
               CASE "PRP3":            GOSUB KillNum  : Ans = gFMD(IX).PrtField("PRP3", lclAttr, lclPos)
               CASE "PRP4":            GOSUB KillNum  : Ans = gFMD(IX).PrtField("PRP4", lclAttr, lclPos)
               CASE "PRP5":            GOSUB KillNum  : Ans = gFMD(IX).PrtField("PRP5", lclAttr, lclPos)
               CASE "PRP6":            GOSUB KillNum  : Ans = gFMD(IX).PrtField("PRP6", lclAttr, lclPos)
               CASE "WRITETIME":       GOSUB KillNum  : Ans = gFMD(IX).LWTime

               CASE ELSE                                          ' Unknown?
                  GOSUB Killit                                    ' Kill with a message
            END SELECT                                            '
            '--------------------------------------------------------------------------------------+
            '- We have something, return it                                                        |
            '--------------------------------------------------------------------------------------+
            FUNCTION = Ans                                        ' Pass back the value
            TP.ErrMsgReset:                                       ' Reset errors
            DoTraceS(Ans)                                         ' Do trace if needed
         END IF
      END IF                                                      '
   END IF                                                         '
   EXIT FUNCTION                                                  '

   KillNum:
      IF vMode = 0 THEN GOSUB KillIt                              ' If NUMERIC, Kill it
      RETURN

   KillAlpha:
      IF vMode THEN GOSUB KillIt                                  ' If ALPHA, Kill it
      RETURN

   KillNoData:
      IF TP.LFlagData(IX) THEN RETURN                             ' Not Data, kill it
      TP.ErrMsgAdd(8, "Line: " + FORMAT$(IX) + " is not a Data line")  ' Set ZRC to fail
      FUNCTION = "": DoTraceS("")                                 ' Setup return
      thinBasic_RunTimeError(%ERR__INTERNAL_DECRIPTION, _         ' Force a thinBasic error
                             "Line: " + FORMAT$(IX) + " is not a Data line")
      EXIT FUNCTION                                               ' Error exit
      RETURN                                                      ' Never executed

   KillIt:
      TP.ErrMsgAdd(8, oname + " is an unsupported " + Which + " variable")  ' Set ZRC to fail
      FUNCTION = "": DoTraceS("")                                 ' Setup return
      thinBasic_RunTimeError(%ERR__NOT_VAR, _                     ' Force a thinBasic error
                             oname + " is an unsupported " + Which + " variable")
      EXIT FUNCTION                                               ' Error exit
      RETURN                                                      ' Never executed

   MaybeClip:
      IF IsClip AND ISNULL(TP.Clipname) THEN                      ' Handle special tabs
         Ans = "ClipBoard"                                        '
      ELSEIF IsSetEdit THEN                                       '
         Ans = "SetEdit"                                          '
      ELSEIF IsEFTEdit THEN                                       '
         Ans = "EFTEdit"                                          '
      ELSE                                                        ' Else
         Ans = ""                                                 ' Return null
      END IF                                                      '
   RETURN                                                         '
END FUNCTION
                                                    '
